#
#  For more information, please see: http://software.sci.utah.edu
# 
#  The MIT License
# 
#  Copyright (c) 2009 Scientific Computing and Imaging Institute,
#  University of Utah.
# 
#  
#  Permission is hereby granted, free of charge, to any person obtaining a
#  copy of this software and associated documentation files (the "Software"),
#  to deal in the Software without restriction, including without limitation
#  the rights to use, copy, modify, merge, publish, distribute, sublicense,
#  and/or sell copies of the Software, and to permit persons to whom the
#  Software is furnished to do so, subject to the following conditions:
# 
#  The above copyright notice and this permission notice shall be included
#  in all copies or substantial portions of the Software.
# 
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
#  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
#  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
#  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
#  DEALINGS IN THE SOFTWARE.
#


##
 #  SmoothMesh.tcl: The SmoothMesh UI
 #  Written by:
 #   Jason Shepherd
 #   Department of Computer Science
 #   University of Utah
 #   March 2006
 ##

catch {rename SCIRun_ChangeMesh_SmoothMesh ""}

itcl::class SCIRun_ChangeMesh_SmoothMesh {
    inherit Module

     constructor { {args ""} } {
        eval configure $args
        set name SmoothMesh
    }

    method ui {} {
        set w .ui[modname]
        if {[winfo exists $w]} {
            raise $w
            return;
        }

        sci_toplevel $w
        #wm minsize $w 80 130

        sci_frame $w.bound -relief groove -borderwidth 2
        sci_label $w.bound.t1 -text "Smooth Boundary"
        pack $w.bound.t1 

        sci_radiobutton $w.bound.smoothboundaryon -text "On" \
            -variable $this-smoothboundary -value "On"
        sci_radiobutton $w.bound.smoothboundaryoff -text "Off" \
            -variable $this-smoothboundary -value "Off"
        pack $w.bound.smoothboundaryon $w.bound.smoothboundaryoff \
            -side left -anchor n

        sci_frame $w.style -relief groove -borderwidth 2
        sci_label $w.style.t1 -text "Smoothing Scheme"
        pack $w.style.t1

        sci_radiobutton $w.style.none -text "None" \
            -variable $this-smoothscheme -value "None"
        sci_radiobutton $w.style.laplacian -text "Laplacian" \
            -variable $this-smoothscheme -value "Laplacian"
        sci_radiobutton $w.style.smartlaplacian -text "Smart Laplacian" \
            -variable $this-smoothscheme -value "SmartLaplacian"
        sci_radiobutton $w.style.shapeimprovement -text "Shape Improvement" \
            -variable $this-smoothscheme -value "ShapeImprovement"
        pack $w.style.none $w.style.laplacian $w.style.smartlaplacian $w.style.shapeimprovement \
            -side top -anchor w


        sci_frame $w.isovalue -relief groove -borderwidth 2
        sci_label $w.isovalue.t1 -text "Addional Constraints"
        pack $w.isovalue.t1 

        sci_radiobutton $w.isovalue.none -text "Do not add constraint" \
            -variable $this-isomethod -value ""
        sci_radiobutton $w.isovalue.lessthan -text "Do not move nodes with values less than isovalue" \
            -variable $this-isomethod -value "LessThan"
        sci_radiobutton $w.isovalue.equalto -text "Do not move nodes with values equal to isovalue" \
            -variable $this-isomethod -value "EqualTo"
        sci_radiobutton $w.isovalue.greaterthan -text "Do not move nodes with values greater than isovalue" \
            -variable $this-isomethod -value "GreaterThan"
        sci_frame $w.isovalue.f 
        
        sci_label $w.isovalue.f.label -text "IsoValue :"
        sci_entry $w.isovalue.f.value  -textvariable $this-isovalue
        pack $w.isovalue.f.label $w.isovalue.f.value -side left -anchor n
                
        pack $w.isovalue.none $w.isovalue.lessthan $w.isovalue.equalto $w.isovalue.greaterthan $w.isovalue.f\
            -side top -anchor w

        pack $w.bound $w.style $w.isovalue -side top -e y -f both -padx 5 -pady 5

        makeSciButtonPanel $w $w $this
        moveToCursor $w
    }
}
