#
#  For more information, please see: http://software.sci.utah.edu
# 
#  The MIT License
# 
#  Copyright (c) 2009 Scientific Computing and Imaging Institute,
#  University of Utah.
# 
#  
#  Permission is hereby granted, free of charge, to any person obtaining a
#  copy of this software and associated documentation files (the "Software"),
#  to deal in the Software without restriction, including without limitation
#  the rights to use, copy, modify, merge, publish, distribute, sublicense,
#  and/or sell copies of the Software, and to permit persons to whom the
#  Software is furnished to do so, subject to the following conditions:
# 
#  The above copyright notice and this permission notice shall be included
#  in all copies or substantial portions of the Software.
# 
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
#  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
#  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
#  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
#  DEALINGS IN THE SOFTWARE.
#


catch {rename ShowTextureSlices ""}

itcl::class SCIRun_Visualization_ShowTextureSlices {
    inherit Module

     constructor { {args ""} } {
        eval configure $args
      set name ShowTextureSlices
    }

    method set_active_tab {act} {
      global $this-cyl_active
      if {$act == "Cylindrical"} {
          set $this-cyl_active 1
      } else {
          set $this-cyl_active 0
      }
    }

    method spin_in {new phi} {
      if {! [regexp "\\A\\d*\\.*\\d+\\Z" $new]} {
          return 0
      } elseif {$new > 360.0 || $new < 0.0} {
          return 0
      } 
      set $phi $new
      $this-c needexecute
      return 1
    }

    method spin_angle {step cyl phi} {
      set newphi [expr [set $phi] + 5 * $step]

      if {$newphi > 360.0} {
          set newphi [expr $newphi - 360.0]
      } elseif {$newphi < 0.0} {
          set newphi [expr 360.0 + $newphi]
      }   
      set $phi $newphi
      $cyl delete 0 end
      $cyl insert 0 [set $phi]
      $this-c needexecute
    }
	
    method add_cyl_tab {cyl} {
      set act "$this state"
      set n "$this-c needexecute "
      global $this-phi_0
      global $this-phi_1
      
      sci_label $cyl.l -text "Select Plane(s)"
      sci_checkbutton $cyl.xp -text "Phi-0 plane" -relief flat \
        -variable $this-draw_phi_0 -onvalue 1 -offvalue 0 \
        -anchor w -command "$n"

      sci_checkbutton $cyl.yp -text "Phi-1 plane" -relief flat \
        -variable $this-draw_phi_1 -onvalue 1 -offvalue 0 \
        -anchor w -command "$n"
      
      sci_checkbutton $cyl.zp -text "Z plane" -relief flat \
        -variable $this-drawZ -onvalue 1 -offvalue 0 \
        -anchor w -command "set $this-drawView 0; $act; $n"
      pack $cyl.l $cyl.xp $cyl.yp $cyl.zp \
        -side top -fill x


      sci_spinner $cyl.sp0 -labeltext "Phi-0 degrees: " \
        -width 10 -fixed 10 \
        -validate "$this spin_in %P $this-phi_0" \
        -decrement "$this spin_angle -1 $cyl.sp0 $this-phi_0" \
        -increment "$this spin_angle 1 $cyl.sp0 $this-phi_0" 

      $cyl.sp0 insert 0 [set $this-phi_0]

      sci_spinner $cyl.sp1 -labeltext "Phi-1 degrees: " \
        -width 10 -fixed 10 \
        -validate "$this spin_in %P $this-phi_1" \
        -decrement "$this spin_angle -1 $cyl.sp1 $this-phi_1" \
        -increment "$this spin_angle 1 $cyl.sp1 $this-phi_1" 

      $cyl.sp1 insert 0 [set $this-phi_1]
      
      pack $cyl.sp0 -side top -fill x
      pack $cyl.sp1 -side top -fill x

      sci_frame $cyl.z
      sci_button $cyl.z.plus -text "+" -command "$this-c MoveWidget zplus 1; $n"
      sci_label $cyl.z.label -text " Z "
      sci_button $cyl.z.minus -text "-" -command "$this-c MoveWidget zplus -1; $n"
      pack $cyl.z.plus $cyl.z.label $cyl.z.minus -side left -fill x -expand 1
      pack $cyl.z -side top -fill x -expand 1
    }
 
    method add_standard_tab {standard} {
      global $this-render_style
      set act "$this state"
      set n "$this-c needexecute "

      sci_label $standard.l -text "Select Plane(s)"
      sci_checkbutton $standard.xp -text "X plane" -relief flat \
        -variable $this-drawX -onvalue 1 -offvalue 0 \
        -anchor w -command "set $this-drawView 0; $act; $n"
      
      sci_checkbutton $standard.yp -text "Y plane" -relief flat \
        -variable $this-drawY -onvalue 1 -offvalue 0 \
        -anchor w -command "set $this-drawView 0; $act; $n"
      
      sci_checkbutton $standard.zp -text "Z plane" -relief flat \
        -variable $this-drawZ -onvalue 1 -offvalue 0 \
        -anchor w -command "set $this-drawView 0; $act; $n"
      
      sci_checkbutton $standard.vp -text "V (view) plane" -relief flat \
        -variable $this-drawView -onvalue 1 -offvalue 0 \
        -anchor w -command \
        "set $this-drawX 0; set $this-drawY 0; set $this-drawZ 0; $act; $n"
      
      
      pack $standard.l $standard.xp $standard.yp $standard.zp $standard.vp \
        -side top -fill x
      
      sci_frame $standard.x
      sci_button $standard.x.plus -text "+" -command "$this-c MoveWidget xplus 1; $n"
      sci_label $standard.x.label -text " X "
      sci_button $standard.x.minus -text "-" -command "$this-c MoveWidget xplus -1; $n"
      pack $standard.x.plus $standard.x.label $standard.x.minus -side left -fill x -expand 1
      pack $standard.x -side top -fill x -expand 1
      
      sci_frame $standard.y
      sci_button $standard.y.plus -text "+" -command "$this-c MoveWidget yplus 1; $n"
      sci_label $standard.y.label -text " Y "
      sci_button $standard.y.minus -text "-" -command "$this-c MoveWidget yplus -1; $n"
      pack $standard.y.plus $standard.y.label $standard.y.minus -side left -fill x -expand 1
      pack $standard.y -side top -fill x -expand 1
      
      sci_frame $standard.z
      sci_button $standard.z.plus -text "+" -command "$this-c MoveWidget zplus 1; $n"
      sci_label $standard.z.label -text " Z "
      sci_button $standard.z.minus -text "-" -command "$this-c MoveWidget zplus -1; $n"
      pack $standard.z.plus $standard.z.label $standard.z.minus -side left -fill x -expand 1
      pack $standard.z -side top -fill x -expand 1
      
      sci_frame $standard.v
      sci_button $standard.v.plus -text "+" -command "$this-c MoveWidget vplus 1; $n"
      sci_label $standard.v.label -text " V "
      sci_button $standard.v.minus -text "-" -command "$this-c MoveWidget vplus -1; $n"
      pack $standard.v.plus $standard.v.label $standard.v.minus -side left -fill x -expand 1
      pack $standard.v -side top -fill x -expand 1
    }

    method ui {} { 
        set w .ui[modname] 

        if {[winfo exists $w]} {
            return
        } else {
	    buildTopLevel
	}
    }

    method buildTopLevel {} {
        set w .ui[modname] 

        if {[winfo exists $w]} { 
            return
        } 
	
        sci_toplevel $w 
        wm withdraw $w

        build_ui
    }
     
    method build_ui {} {
        set w .ui[modname]
        set n "$this-c needexecute "
        sci_frame $w.main -relief flat
        pack $w.main -fill both -expand yes

        #wm minsize $w 250 300
        sci_labeledframe $w.main.frame_title \
          -labelpos nw -labeltext "Plane Options"
        set dof [$w.main.frame_title childsite]

        sci_tabnotebook  $dof.tabs -height 250 -raiseselect true 

        global standard
        set st "Standard"
        set standard [$dof.tabs add -label $st \
              -command "$this set_active_tab $st"]

        add_standard_tab $standard

        global cyl
        set c "Cylindrical"
        set cyl [$dof.tabs add -label $c \
               -command "$this set_active_tab $c; $n"]

        add_cyl_tab $cyl
        $dof.tabs view "Standard"	
        $dof.tabs configure -tabpos "n"
        $dof.tabs pageconfigure 0 -command "$this set_active_tab $st; $n"
        pack $dof.tabs -side top -expand yes

        pack $w.main.frame_title -side top -expand yes

      #  	checkbutton $w.main.cb -text "use stencil" \
      #  	    -variable $this-use_stencil -command $n
      #  	pack $w.main.cb -side top
        sci_frame $w.main.f4 -relief flat -borderwidth 0
        pack $w.main.f4 -fill x -expand yes

        if { [set $this-multi_level] > 1 } {
            $this build_multi_level
        }
        
        sci_frame $w.main.f3 -relief groove -borderwidth 2
        pack $w.main.f3 -padx 4 -pady 4 -fill x -side top

        sci_label $w.main.f3.l -text "Interpolation Mode"
        sci_radiobutton $w.main.f3.interp -text "Interpolate" -relief flat \
          -variable $this-interp_mode -value 1 \
          -anchor w -command $n

        sci_radiobutton $w.main.f3.near -text "Nearest" -relief flat \
          -variable $this-interp_mode -value 0 \
          -anchor w -command $n

        pack $w.main.f3.l $w.main.f3.interp $w.main.f3.near -side top -fill x -padx 4 -pady 2
        
        makeSciButtonPanel $w.main $w $this
        $this state 
        moveToCursor $w
    }


    method state {} {
        set inactivecolor "#010101"
        set w .ui[modname]
        global standard

        if {[set $this-drawX] == 1} {
            $this activate $standard.x.plus 
            $standard.x.label configure -foreground black
            $this  activate $standard.x.minus
        } else {
           $this  deactivate $standard.x.plus 
            $standard.x.label configure -foreground $inactivecolor
            $this deactivate $standard.x.minus
        }

        if {[set $this-drawY] == 1} {
            $this activate $standard.y.plus 
            $standard.y.label configure -foreground black
            $this activate $standard.y.minus
        } else {
           $this  deactivate $standard.y.plus 
            $standard.y.label configure -foreground $inactivecolor
            $this deactivate $standard.y.minus
        }
        if {[set $this-drawZ] == 1} {
            $this activate $standard.z.plus 
            $standard.z.label configure -foreground black
            $this activate $standard.z.minus
        } else {
            $this deactivate $standard.z.plus 
            $standard.z.label configure -foreground $inactivecolor
            $this deactivate $standard.z.minus
        }
        if {[set $this-drawView] == 1} {
            $this activate $standard.v.plus 
            $standard.v.label configure -foreground black
            $this activate $standard.v.minus
        } else {
            $this deactivate $standard.v.plus 
            $standard.v.label configure -foreground $inactivecolor
            $this deactivate $standard.v.minus
        }

    }
    method activate { w } {
        $w configure -state normal -foreground black
    }
    method deactivate { w } {
        set inactivecolor "#010101"
        $w configure -state disabled -foreground $inactivecolor
    }

    method build_multi_level { } {
      set w .ui[modname]
      if {[winfo exists $w]} {
          sci_frame $w.main.f4.f -relief groove -borderwidth 2
          pack $w.main.f4.f -padx 2 -pady 2 -fill x -expand yes -side top
          sci_frame $w.main.f4.f.f1 -relief flat -borderwidth 2
          pack $w.main.f4.f.f1 -padx 2 -pady 2 -fill x -expand yes
          sci_checkbutton $w.main.f4.f.f1.stencil -text "Use Stencil" \
            -variable $this-use_stencil -command "$this-c needexecute"
          sci_checkbutton $w.main.f4.f.f1.opacity -text "Outline Levels" \
            -variable $this-outline_levels -command "$this-c needexecute"
          pack $w.main.f4.f.f1.stencil $w.main.f4.f.f1.opacity -side left
          
          sci_frame $w.main.f4.f.f2 -relief flat -borderwidth 2
          pack $w.main.f4.f.f2 -padx 2 -pady 2 -fill x -expand yes
          sci_label $w.main.f4.f.f2.l -text "Show level"
          pack $w.main.f4.f.f2.l -side left
          sci_frame $w.main.f4.f.f2.f -relief flat -borderwidth 2
          pack $w.main.f4.f.f2.f -side right -expand yes -fill x
          set selected 0
          for { set i 0 } { $i < [set $this-multi_level] } { incr i } {
            sci_checkbutton $w.main.f4.f.f2.f.b$i -text $i \
              -variable $this-l$i -command "$this set_level $i" 
            pack $w.main.f4.f.f2.f.b$i -side left
                    if { $i < [llength [set $this-level_on]] } {
                        if { [lindex [set $this-level_on] $i] == 1 } {
                            $w.main.f4.f.f2.f.b$i select
                            set selected 1
                        }
                    } else  {
                        set $this-level_on [linsert [set $this-level_on] $i 0]
                    }
                    addColorSelection $w.main.f4.f.f2.f $i \
                        $this-def-color "color_changed"
          }
          if { !$selected && [winfo exists $w.main.f4.f.f2.f.b0] } {  
            $w.main.f4.f.f2.f.b0 select 
            set $this-level_on [linsert [set $this-level_on] 0 1]
          }
      }
    }
    method set_level { i } {
        if { $i < [llength [set $this-level_on]] } {
            set on [lindex [set $this-level_on] $i]
              if { $on == 0 } {
                  set $this-level_on [lreplace [set $this-level_on] $i $i 1]
              } else {
                  set $this-level_on [lreplace [set $this-level_on] $i $i 0]
              }
          }
        $this-c needexecute
    }
         
    method destroy_multi_level { } {
        set w .ui[modname]
        if {[winfo exists $w.main]} {
            destroy $w.main
        }
        build_ui
    }

    method hasUI {} {
        return [winfo exists .ui[modname]]
    }

    method isOn { bval } {
        return  [set $this-$bval]
    }

    method getOutlineColors { } {
        set csize [llength [set $this-colors]]
        set scolors [join [set $this-colors]]
        return "$csize $scolors"
    }
    
    method raiseColor {col i color colMsg} {
       global $color
       set window .ui[modname]
       if {[winfo exists $window.color]} {
           SciRaise $window.color
           return
       } else {
         # first set the default color
         set c [lindex [set $this-colors] $i]
         set $color-r [lindex $c 0]
         set $color-g [lindex $c 1]
         set $color-b [lindex $c 2]

         # makeColorPicker now creates the $window.color toplevel.
         makeColorPicker $window.color $color \
           "$this setColor $col $i $color $colMsg" \
           "destroy $window.color"
       }
    }

    method setColor {col i color colMsg} {
        global $color
        global $color-r
        global $color-g
        global $color-b

        set ir [expr int([set $color-r] * 65535)]
        set ig [expr int([set $color-g] * 65535)]
        set ib [expr int([set $color-b] * 65535)]

        set c [list [set $color-r] [set $color-g] [set $color-b] ]
        set $this-colors [lreplace [set $this-colors] $i $i $c]

        set window .ui[modname]
        $col configure -background [format #%04x%04x%04x $ir $ig $ib]
        set $this-color_changed 1                        
        $this-c needexecute
    }

    method addColorSelection {frame i color colMsg} {
        #add node color picking 
        global $color
        global $color-r
        global $color-g
        global $color-b
             
        set length [llength [set $this-colors]]
        if { $i < $length } {
           
           set c [lindex [set $this-colors] $i]
           set ir [expr int([lindex $c 0] * 65535)]
           set ig [expr int([lindex $c 1] * 65535)]
           set ib [expr int([lindex $c 2] * 65535)]

        } else {
           set ir [expr int([set $color-r] * 65535)]
           set ig [expr int([set $color-g] * 65535)]
           set ib [expr int([set $color-b] * 65535)]
           set c [list [set $color-r] [set $color-g] [set $color-b] ]
           set $this-colors [linsert [set $this-colors] $i $c ]
        }
        sci_frame $frame.f$i
        set cmmd "$this raiseColor $frame.f$i.set_color $i $color $colMsg"

        sci_button $frame.f$i.set_color -command $cmmd \
                             -height 1 -width 2
        $frame.f$i.set_color configure -background [format #%04x%04x%04x $ir $ig $ib]

        #pack the node color frame
        pack $frame.f$i.set_color -side left
        pack $frame.f$i -side left

    }

}

