#
#  For more information, please see: http://software.sci.utah.edu
# 
#  The MIT License
# 
#  Copyright (c) 2009 Scientific Computing and Imaging Institute,
#  University of Utah.
# 
#  
#  Permission is hereby granted, free of charge, to any person obtaining a
#  copy of this software and associated documentation files (the "Software"),
#  to deal in the Software without restriction, including without limitation
#  the rights to use, copy, modify, merge, publish, distribute, sublicense,
#  and/or sell copies of the Software, and to permit persons to whom the
#  Software is furnished to do so, subject to the following conditions:
# 
#  The above copyright notice and this permission notice shall be included
#  in all copies or substantial portions of the Software.
# 
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
#  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
#  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
#  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
#  DEALINGS IN THE SOFTWARE.
#


itcl::class SCIRun_MiscField_SelectFieldROIWithBoxWidget {
    inherit Module

     constructor { {args ""} } {
        eval configure $args
        set name SelectFieldROIWithBoxWidget
    }

    method replace {} {
      set $this-runmode 2
      $this-c needexecute
    }

    method accumulate {} {
      set $this-runmode 1
      $this-c needexecute
    }

    method ui {} {
      set w .ui[modname]
      if {[winfo exists $w]} {
          return
      }
      sci_toplevel $w

      sci_frame $w.row1
      sci_frame $w.row3
      sci_frame $w.row4

      pack $w.row1 $w.row3 $w.row4 -side top -e y -f both -padx 5 -pady 5
      
      sci_label $w.row1.value_label -text "Selection Value"
      sci_entry $w.row1.value -textvariable $this-stampvalue
      pack $w.row1.value_label $w.row1.value -side left

      sci_button $w.row3.execute -text "Replace" -command "$this replace"
      pack $w.row3.execute -side top -e n -f both

      sci_button $w.row4.execute -text "Accumulate" -command "$this accumulate"
      pack $w.row4.execute -side top -e n -f both

      makeSciButtonPanel $w $w $this
      moveToCursor $w
    }
}


