##
#
#  For more information, please see: http://software.sci.utah.edu
# 
#  The MIT License
# 
#  Copyright (c) 2009 Scientific Computing and Imaging Institute,
#  University of Utah.
# 
#  
#  Permission is hereby granted, free of charge, to any person obtaining a
#  copy of this software and associated documentation files (the "Software"),
#  to deal in the Software without restriction, including without limitation
#  the rights to use, copy, modify, merge, publish, distribute, sublicense,
#  and/or sell copies of the Software, and to permit persons to whom the
#  Software is furnished to do so, subject to the following conditions:
# 
#  The above copyright notice and this permission notice shall be included
#  in all copies or substantial portions of the Software.
# 
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
#  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
#  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
#  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
#  DEALINGS IN THE SOFTWARE.
#

itcl::class SCIRun_ChangeFieldData_ProjectLocalMaxOnSurface {
    inherit Module
     
    constructor { {args ""} } {
        eval configure $args
        set name ProjectLocalMaxOnSurface
		set_defaults
    }
	
	method set_defaults {} {
	global $this-method
	global $this-ed-method
	global $this-ed
	
	set $this-method "visualization"
	set $this-ed-method "projection"
	set $this-ed "settings"
	}

    method ui {} {
        set w .ui[modname]
        if {[winfo exists $w]} {
            return
        }
        sci_toplevel $w

        sci_frame $w.f
        pack $w.f -fill x
		
		sci_tabnotebook $w.f.filters -height 150 -width 300 -tabpos n
		$w.f.filters add -label "Visualization" -command "set $this-method visualization"
		$w.f.filters add -label "Settings" -command "set $this-ed settings"
		$w.f.filters select 0
		
		pack $w.f.filters -fill x -expand yes
		
		set visualization [$w.f.filters childsite 0]
		set settings [$w.f.filters childsite 1]
		
		sci_frame $visualization.f
		pack $visualization.f -side left -padx 5p -anchor n
		
		sci_radiobutton $visualization.f.projection -text "Projection" -variable $this-ed-method -value "projection"
		sci_radiobutton $visualization.f.transmurality -text "Transmurality" -variable $this-ed-method -value "transmurality"
        
		grid $visualization.f.projection -row 0 -column 1 -sticky w
		grid $visualization.f.transmurality -row 1 -column 1 -sticky w
		
		sci_frame $settings.f
		pack $settings.f -side left -padx 5p -anchor n
		
        sci_label $settings.f.lab1 -text "Box size"
		sci_label $settings.f.lab2 -text "Lateral Distance"
        sci_label $settings.f.lab3 -text "Projection Distance onto Normal"
        sci_label $settings.f.lab4 -text "Number of Layers"
        sci_label $settings.f.lab5 -text "Threshold"

        grid $settings.f.lab1 -row 0 -column 0 -sticky e
        grid $settings.f.lab2 -row 1 -column 0 -sticky e
        grid $settings.f.lab3 -row 2 -column 0 -sticky e
        grid $settings.f.lab4 -row 3 -column 0 -sticky e
        grid $settings.f.lab5 -row 4 -column 0 -sticky e

        sci_entry $settings.f.boxsize -textvariable $this-boxsize
		sci_entry $settings.f.lateraldistance -textvariable $this-lateraldistance
		sci_entry $settings.f.projectiondistance -textvariable $this-projectiondistance
		sci_entry $settings.f.numlayers -textvariable $this-numlayers
		sci_entry $settings.f.thresh -textvariable $this-thresh
        
        grid $settings.f.boxsize -row 0 -column 1 -sticky news
		grid $settings.f.lateraldistance -row 1 -column 1 -sticky news
		grid $settings.f.projectiondistance -row 2 -column 1 -sticky news
        grid $settings.f.numlayers -row 3 -column 1 -sticky news
		grid $settings.f.thresh -row 4 -column 1 -sticky news

        makeSciButtonPanel $w $w $this
        moveToCursor $w
    }
}


