#
#  For more information, please see: http://software.sci.utah.edu
# 
#  The MIT License
# 
#  Copyright (c) 2009 Scientific Computing and Imaging Institute,
#  University of Utah.
# 
#  
#  Permission is hereby granted, free of charge, to any person obtaining a
#  copy of this software and associated documentation files (the "Software"),
#  to deal in the Software without restriction, including without limitation
#  the rights to use, copy, modify, merge, publish, distribute, sublicense,
#  and/or sell copies of the Software, and to permit persons to whom the
#  Software is furnished to do so, subject to the following conditions:
# 
#  The above copyright notice and this permission notice shall be included
#  in all copies or substantial portions of the Software.
# 
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
#  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
#  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
#  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
#  DEALINGS IN THE SOFTWARE.
#


itcl::class SCIRun_NewField_CreateImage {
    inherit Module

     constructor { {args ""} } {
        eval configure $args
        set name CreateImage
    }

    method update-type { w } {
	global $this-update_type
	set $this-update_type [$w get]
    }

    method position_release { } {
	global $this-update_type

	set type [set $this-update_type]
	if { $type == "On Release" } {
	    $this-c needexecute
	}
    }

    method set_position {v} {
	global $this-update_type

	set type [set $this-update_type]
	if { $type == "Auto" } {
	    $this-c needexecute
	}
    }


    method edit_scale { } {
        set w .ui[modname]
        if { ![winfo exists $w] } {
            return
        }

        if { [set $this-auto_size] == 0 } {
            $w.row4.scale configure -from -1.0 -to 1.0 -resolution .01 \
                -variable $this-pos
            $w.row4.l2 configure -state disabled
            set fgc [$w.row4.l2 cget -disabledforeground]
            $w.row4.entry configure -state disabled -foreground $fgc
            
        } else {
            $w.row4.scale configure -from 0 -to [expr [set $this-sizez] - 1] \
                -resolution 1  -variable $this-z_value
            $w.row4.l2 configure -state normal
            set fgc [$w.row4.l2 cget -foreground]
            $w.row4.entry configure -state normal -foreground $fgc
        }
    }

    method ui {} {
        set w .ui[modname]
        if {[winfo exists $w]} {
            return
        }
        sci_toplevel $w

        sci_frame $w.row1
        sci_frame $w.row2
        sci_frame $w.row21
        sci_frame $w.row3
        sci_frame $w.row31
        sci_frame $w.row32
        sci_frame $w.row4
        sci_frame $w.row5
        sci_frame $w.which -relief groove -borderwidth 2

        pack $w.row1 $w.row2 $w.row21 $w.row3 $w.row31 $w.row32 \
                  $w.row4 $w.row5 $w.which \
                  -side top -e y -f both -padx 5 -pady 5
        
        sci_label $w.row1.xsize_label -text "Width    "
        sci_entry $w.row1.xsize -textvariable $this-sizex
        sci_radiobutton $w.row1.auto_size  -text "Manual size" -value 0 \
                 -variable $this-auto_size -borderwidth 2 -command "$this edit_scale"
        sci_label $w.row2.ysize_label -text "Height   "
        sci_entry $w.row2.ysize -textvariable $this-sizey
        sci_radiobutton $w.row2.auto_size  -text "Auto size" -value 1 \
                 -variable $this-auto_size -borderwidth 2 -command "$this edit_scale"

        pack $w.row1.xsize_label $w.row1.xsize $w.row1.auto_size -side left
        pack $w.row2.ysize_label $w.row2.ysize $w.row2.auto_size -side left

        sci_label $w.row21.zsize_label -text "Pad Percentage"
        sci_entry $w.row21.zsize -textvariable $this-padpercent
        pack $w.row21.zsize_label $w.row21.zsize -side left

        sci_label $w.row3.label -text "Axis: "
        sci_radiobutton $w.row3.x -text "X    " -variable $this-axis -value 0 \
                  -command "$this set_position [set $this-z_value]"
        sci_radiobutton $w.row3.y -text "Y    " -variable $this-axis -value 1 \
                  -command "$this set_position [set $this-z_value]"
        sci_radiobutton $w.row3.z -text "Z    " -variable $this-axis -value 2 \
                  -command "$this set_position [set $this-z_value]"
        sci_radiobutton $w.row3.c -text "Custom" -variable $this-axis -value 3 \
                  -command "$this set_position [set $this-z_value]"
        pack $w.row3.label $w.row3.x $w.row3.y $w.row3.z $w.row3.c -side left

        sci_label $w.row31.lab -text "Custom Origin:   "
        sci_entry $w.row31.ex -textvariable $this-corigin-x -width 8
        sci_entry $w.row31.ey -textvariable $this-corigin-y -width 8
        sci_entry $w.row31.ez -textvariable $this-corigin-z -width 8
        pack $w.row31.lab $w.row31.ex $w.row31.ey $w.row31.ez -side left
        sci_label $w.row32.lab -text "Custom Normal: "
        sci_entry $w.row32.ex -textvariable $this-cnormal-x -width 8
        sci_entry $w.row32.ey -textvariable $this-cnormal-y -width 8
        sci_entry $w.row32.ez -textvariable $this-cnormal-z -width 8
        pack $w.row32.lab $w.row32.ex $w.row32.ey $w.row32.ez -side left

        sci_label $w.row4.l1 -text "Position: "
        sci_scale $w.row4.scale -width 10 -orient horizontal \
                  -command "$this set_position" 
        sci_label $w.row4.l2 -text " index: "
        sci_entry $w.row4.entry -textvariable $this-z_value  -width 12


        sci_optionmenu $w.row5.update -labeltext "Update:" \
            -labelpos w -command "$this update-type $w.row5.update"
        $w.row5.update insert end "On Release" Manual Auto
        $w.row5.update select [set $this-update_type]

        bind $w.row3.x <ButtonRelease> "$this position_release"
        bind $w.row3.y <ButtonRelease> "$this position_release"
        bind $w.row3.z <ButtonRelease> "$this position_release"
        bind $w.row3.c <ButtonRelease> "$this position_release"
        bind $w.row4.scale <ButtonRelease> "$this position_release"
              bind $w.row4.entry <Return> "$this position_release"
        
        pack $w.row4.l1 $w.row4.scale $w.row4.l2 $w.row4.entry -side left \
                  -anchor s
        pack $w.row5.update -side left

        sci_label $w.which.l -text "Data At Location"
        sci_radiobutton $w.which.node -text "Nodes (linear basis)" \
          -variable $this-data-at -value Nodes
        sci_radiobutton $w.which.face -text "Faces (constant basis)" \
          -variable $this-data-at -value Faces
        sci_radiobutton $w.which.none -text "None" \
          -variable $this-data-at -value None
        pack $w.which.l -side top
        pack $w.which.node $w.which.face $w.which.none -anchor nw

        makeSciButtonPanel $w $w $this
        moveToCursor $w

        $this edit_scale

    }
}


