#include <iostream>
#include <iomanip>
#include <sstream>
#include <fstream>
#include <vector>
#include <list>
#include <algorithm>
#include <stdexcept>
#include <math.h>

#include "Student.h"
#include "Person.h"
#include "myFun.h"

using namespace std;

//----------------------------------------------------------

void example1()
{
  // What will this print?
  // a) Found 5
  // b) Didn't find it
  // c) crash

  list<int> ints;
  ints.push_back(1);
  ints.push_back(2);
  ints.push_back(3);
  ints.push_back(4);

  list<int>::iterator result = myFind(ints.begin(), ints.end(), 4);
  if (result != ints.end()) {
    cout << "Found " << *result << endl;
  }
  else {
    cout << "Didn't find it" << endl;
  }

  // Can we write our own find function?
  // Why are they called function templates?
}

//----------------------------------------------------------

void printInt(const int& x)
{
  cout << x << " ";
}

void example2()
{
  // What will this print?
  // a) Found 5
  // b) Didn't find it
  // c) 1 2 3
  // d) 1 2 3 4

  list<int> ints;
  ints.push_back(1);
  ints.push_back(2);
  ints.push_back(3);
  ints.push_back(4);

  vector<int> myCopy;

  copy(ints.begin(), ints.end(), back_inserter(myCopy));
  for_each(myCopy.begin(), myCopy.end(), printInt);
  cout << endl;
}

//----------------------------------------------------------

void example3()
{
  // What will this print?
  // a) Jimmy
  // b) Jane
  // c) 21
  // d) None of the above

  string s = 
    "Jimmy 21 -A 92 "
    "Jane 18 B+ 89 "
    "Cornelia 23 A 88 "
    "Zoltan 20 -A 95 ";

  vector<Student> students = Student::readStudents(s);
  const Student& student = students[0];
  cout << student.getName() << endl;

  // What about when I change the struct to be a class?
  // What if I change the student variable to be a const?
}

//----------------------------------------------------------

void example4()
{
  // What will this print?
  // a) Jimmy
  // b) Jane
  // c) 21
  // d) None of the above

  string s = 
    "Jimmy 21 -A 92 "
    "Jane 18 B+ 89 "
    "Cornelia 23 A 88 "
    "Zoltan 20 -A 95 ";

  vector<Student> students = Student::readStudents(s);
  Student& student = students[0];
  //student.name = "James";
  //cout << student.name << endl;

  // What if I want a toString() function?
}

//----------------------------------------------------------

void example5()
{
  Student student("Giovanni", 22, "A", 88);

  // What can I do to improve this code?
}

//----------------------------------------------------------

void example6()
{
  // What will the following print?
  // a) 1 2
  // b) 1 C2 2
  // c) 1 C2 2 D
  // d) 1 C1 C2 2 D

  cout << "1" << endl;
  Person person("Brunhilda", 53);
  cout << "2" << endl;

  // Should Student inherit from Person?
}

//----------------------------------------------------------

void example7()
{
}

//----------------------------------------------------------

void example8()
{
}

//----------------------------------------------------------

void example9()
{
}

//----------------------------------------------------------

void example10()
{
}

//----------------------------------------------------------

void example11()
{
}

//----------------------------------------------------------

void example12()
{
}

//----------------------------------------------------------

void example13()
{
}

//----------------------------------------------------------

void example14()
{
}

//----------------------------------------------------------

void example15()
{
}


int main(int argc, char** argv)
{
  string option;
  if (argc > 1) {
    option = argv[1];
  }
  if (option == "1") {
    example1();
  }
  if (option == "2") {
    example2();
  }
  if (option == "3") {
    example3();
  }
  if (option == "4") {
    example4();
  }
  if (option == "5") {
    example5();
  }
  if (option == "6") {
    example6();
  }
  if (option == "7") {
    example7();
  }
  if (option == "8") {
    example8();
  }
  if (option == "9") {
    example9();
  }
  if (option == "10") {
    example10();
  }
  if (option == "11") {
    example11();
  }
  if (option == "12") {
    example12();
  }
  if (option == "13") {
    example13();
  }
  if (option == "14") {
    example14();
  }
  if (option == "15") {
    example15();
  }
  return 0;
}
