#ifndef __STUDENT_H__
#define __STUDENT_H__

#include <vector>
#include <iostream>

// Student structure that stores all things
// relative.
class Student
{
private:
  std::string name;
  int age;
  std::string grade;
  int niceness;

public:
  Student() {}
  Student(std::string n, int a, std::string g, int ni)
  {
    name = n;
    age = a;
    grade = g;
    niceness = ni;
  }
  std::string getName() const
  { 
    return name; 
  }

public:
  // Functions to read a student or students from 
  // various media
  static Student readStudent(std::istream& in);
  static std::vector<Student> readStudents(std::istream& in);
  static std::vector<Student> readStudents(std::string s);

  // Overloaded operator for outputting a relative.
  friend std::ostream& operator<<(std::ostream& out, const Student& r);
};

#endif
