#include <sstream>
#include <iomanip>
#include "Student.h"

using namespace std;

// Reads a student from the stream and returns
// a copy.  The input stream pointer is left at
// the end of the relative.
Student Student::readStudent(istream& in)
{
  Student r;
  in >> r.name >> r.age >> r.grade >> r.niceness;
  return r;
}

// Reads the stream to EOF looking for relatives.
std::vector<Student> Student::readStudents(istream& in)
{
  std::vector<Student> relatives;
  while (in) {
    Student r = readStudent(in);
    if (in) {
      relatives.push_back(r);
    }
  }
  return relatives;
}

// Reads relatives from a string formatted as
//   name1 type1 age1 niceness1
//   name2 type2 age2 niceness2
//   ...
//   namen typen agen nicenessn
std::vector<Student> Student::readStudents(string s)
{
  stringstream ss(stringstream::in | stringstream::out);
  ss << s;
  return readStudents(ss);
}

// Overloaded operator for outputting a relative.
ostream& operator<<(ostream& out, const Student& r)
{
  out << std::left << setw(18) << r.name 
      << " age: " << setw(2) << r.age 
      << " grade: " << setw(2) << r.grade 
      << " niceness: " << r.niceness;
  return out;
}

