#include <iostream>
#include <fstream>
#include <list>
#include <ctime>

#include "xyzi.h"
#include "Point.h"
#include "stats.h"

using namespace std;

int main()
{
  int numPoints = 440354;
  ifstream in("lyon.xyzi");
  Point** points = readxyzi(in, numPoints);
  in.close();

  double avg = calcAverage(points, numPoints);
  double sd = calcStdDev(points, numPoints, avg);
  cout << "lyon: average = " << avg << ", standard dev = " << sd << endl;

  for (int i = 0; i < numPoints; ++i) {
    if ((*(points+i))->z() > avg + 1.5 * sd) {
      Point* newPoint = new Point(*(*(points+i)));
      newPoint->z() = avg + 1.5 * sd;
      delete (*(points+i));
      (*(points+i)) = newPoint;
    }
    else if ((*(points+i))->z() > avg + 1 * sd) {
      Point* newPoint = new Point(*(*(points+i)));
      newPoint->z() = avg + 1 * sd;
      delete (*(points+i));
      (*(points+i)) = newPoint;
    }
    else if ((*(points+i))->z() > avg + 0.5 * sd) {
      Point* newPoint = new Point(*(*(points+i)));
      newPoint->z() = avg + 0.5 * sd;
      (*(points+i)) = newPoint;
      delete (*(points+i));
    }
    else if ((*(points+i))->z() > avg) {
      Point* newPoint = new Point(*(*(points+i)));
      newPoint->z() = avg;
      delete (*(points+i));
      (*(points+i)) = newPoint;
    }
    else if ((*(points+i))->z() > avg - 0.5 * sd) {
      Point* newPoint = new Point(*(*(points+i)));
      newPoint->z() = avg - 0.5 * sd;
      delete (*(points+i));
      (*(points+i)) = newPoint;
    }
    else if ((*(points+i))->z() > avg - 1.0 * sd) {
      Point* newPoint = new Point(*(*(points+i)));
      newPoint->z() = avg - 1.0 * sd;
      delete (*(points+i));
      (*(points+i)) = newPoint;
    }
    else if ((*(points+i))->z() > avg - 1.5 * sd) {
      Point* newPoint = new Point(*(*(points+i)));
      newPoint->z() = avg - 1.5 * sd;
      delete (*(points+i));
      (*(points+i)) = newPoint;
    }
    else {
      Point* newPoint = new Point(*(*(points+i)));
      newPoint->z() = avg - 2.0 * sd;
      delete (*(points+i));
      (*(points+i)) = newPoint;
    }
  }

  ofstream out("lyon_new.xyzi");
  writexyzi(out, points, numPoints);
  out.close();
}
